#ifndef _CUSTOMGUI_BASE_H_
#define _CUSTOMGUI_BASE_H_

#include "c4d_library.h"
#include "c4d_basecontainer.h"
#include "c4d_gui.h"
#include "c4d_baseplugin.h"

struct BaseCustomGuiLib;

// general properties for CustomGui's
#define CUSTOMGUI_LAYOUTMODE					'laym'
#define CUSTOMGUI_DEFAULTEDITHEIGHT		'defh'

class _BaseCustomGui
{
		_BaseCustomGui();

	public:

		LONG GetWidth(LONG plugid);
		LONG GetHeight(LONG plugid);
		void Redraw(LONG plugid);
		Bool LayoutChanged(LONG plugid);
		Bool Activate(LONG plugid);
		Bool SetDefaultForResEdit(LONG plugid);
		Bool SetData(LONG plugid,const TriState<GeData> &tristate);
		TriState<GeData> GetData(LONG plugid);
		void SetLayoutMode(LONG plugid,LONG mode);
		LONG GetLayoutMode(LONG plugid);
		Bool SupportLayoutSwitch(LONG plugid);
};

template <LONG plugid> class BaseCustomGui : public _BaseCustomGui
{
		BaseCustomGui();

	public:

		LONG GetWidth()																		{ return _BaseCustomGui::GetWidth(plugid);	}
		LONG GetHeight()																	{ return _BaseCustomGui::GetHeight(plugid); }
		void Redraw()																			{ _BaseCustomGui::Redraw(plugid);		}
		Bool LayoutChanged()															{ return _BaseCustomGui::LayoutChanged(plugid); }
		Bool Activate()																		{ return _BaseCustomGui::Activate(plugid); }
		Bool SetDefaultForResEdit()												{ return _BaseCustomGui::SetDefaultForResEdit(plugid); }
		Bool SetData(const TriState<GeData> &tristate)		{	return _BaseCustomGui::SetData(plugid,tristate);}
		TriState<GeData> GetData()												{	return _BaseCustomGui::GetData(plugid);	}
		void SetLayoutMode(LONG mode)											{	_BaseCustomGui::SetLayoutMode(plugid,mode); }
		LONG GetLayoutMode()															{	return _BaseCustomGui::GetLayoutMode(plugid);	}
		Bool SupportLayoutSwitch()												{	return _BaseCustomGui::SupportLayoutSwitch(plugid);	}
};


void FillBaseCustomGui(BaseCustomGuiLib &lib);



// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#ifndef _INTERNAL_BASECUSTOM_
	class iBaseCustomGui : public iCustomGui 
	{
		public:
			iBaseCustomGui(const BaseContainer &settings,CUSTOMGUIPLUGIN *plugin) : iCustomGui(settings,plugin) { }
	};
#else
	class iBaseCustomGui : public iCustomGui
	{
		public:
			iBaseCustomGui(const BaseContainer &settings,CUSTOMGUIPLUGIN *plugin) : iCustomGui(settings,plugin) { }
	};
#endif

struct BaseCustomGuiLib : public C4DLibrary
{
	void							(iBaseCustomGui::*Redraw								)();
	Bool							(iBaseCustomGui::*LayoutChanged					)();
	LONG							(iBaseCustomGui::*GetWidth							)();
	LONG							(iBaseCustomGui::*GetHeight							)();
	Bool							(iBaseCustomGui::*Activate							)();
	Bool							(iBaseCustomGui::*SetDefaultForResEdit	)();
	Bool							(iBaseCustomGui::*SetData)(const TriState<GeData> &tristate);
	TriState<GeData>	(iBaseCustomGui::*GetData)();
	void							(iBaseCustomGui::*SetLayoutMode)(LONG mode);
	LONG							(iBaseCustomGui::*GetLayoutMode)();
	Bool							(iBaseCustomGui::*SupportLayoutSwitch)();

	void*		reserved[(32-11)*C4DPL_MEMBERMULTIPLIER];
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif
